#ifndef usb_R8_3H
#define usb_R8_3H
#include <objbase.h>
#include <cstring>
using namespace std;
#define bufferLength 32
#define searchMaxDevice 10
//--------------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//--------------------------------------------------------------
typedef struct _HIDD_ATTRIBUTES {
    ULONG Size;
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;
//--------------------------------------------------------------
void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
bool (__stdcall *HidD_GetAttributes)(IN HANDLE HidDeviceObject,
                                    OUT PHIDD_ATTRIBUTES Attributes);
//--------------------------------------------------------------
interface ISynchronous {
   public:
     virtual bool __stdcall synchReadUSBReport(HANDLE hidDevObject,
             void *inputReportBuffer, ULONG inputReportBufferLength) = 0;
     virtual  HANDLE __stdcall synchOpenUSBDevice() = 0;
     virtual void __stdcall setUshortVid(USHORT vid) = 0;
     virtual ~ISynchronous() {};
};
//--------------------------------------------------------------
interface IAsynchronous {
   public:
     virtual bool __stdcall asynchReadUSBReport(HANDLE hidDevObject,
             void *inputReportBuffer, ULONG inputReportBufferLength)= 0;
     virtual  HANDLE __stdcall asynchOpenUSBDevice() = 0;
     virtual void __stdcall setCharVid(const char* vid) = 0;
     virtual ~IAsynchronous() {};
};
//--------------------------------------------------------------
class TUSBDevice: public ISynchronous, public IAsynchronous {
   private:
     string pathUSBDevice;
     DWORD memberIndex;
     HIDD_ATTRIBUTES hiddAttributes;
     PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData;
     DWORD numberOfBytesRead;
     DWORD result;
     GUID classGuid;
     HMODULE hHidLib;
     DWORD deviceInterfaceDetailDataSize;
     HDEVINFO deviceInfoSet;
     SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
     USHORT usVid;
     const char *chVid;
   public:
     TUSBDevice();
     ~TUSBDevice();
     void __stdcall setUshortVid(USHORT vid);
     void __stdcall setCharVid(const char *vid);
     void __stdcall displayError(const char* msg);
     bool __stdcall synchReadUSBReport(HANDLE hidDevObject,
                void *inputReportBuffer, ULONG inputReportBufferLength);
     bool __stdcall asynchReadUSBReport(HANDLE hidDevObject,
                void *inputReportBuffer, ULONG inputReportBufferLength);
     HANDLE __stdcall synchOpenUSBDevice();
     HANDLE __stdcall asynchOpenUSBDevice();
     string __stdcall getUSBDevicePath(UINT);
};
//--------------------------------------------------------------
#endif
//--------------------------------------------------------------

